(function($){

    // A lightweight throttle Function
    function throttle(fn, threshhold, scope) {
        threshhold || (threshhold = 100);
        var last,
            deferTimer;
        return function () {
            var context = scope || this;

            var now = +new Date,
                args = arguments;
            if (last && now < last + threshhold) {
                // hold on to it
                clearTimeout(deferTimer);
                deferTimer = setTimeout(function () {
                    last = now;
                    fn.apply(context, args);
                }, threshhold);
            } else {
                last = now;
                fn.apply(context, args);
            }
        };
    }

    // ACCESSIBILITY HOVERS
    $('#navigation a').focus(function() {
        $(this).parents('li').addClass('focus');
    });
    $('#navigation a').blur(function() {
        $(this).parents('li').removeClass('focus');
    });
    $('.no-touchevents #navigation a').focus(function() {
        $('body').addClass('menu-active');
    });
    $('.no-touchevents #main a').focus(function() {
        $('body').removeClass('menu-active');
    });

    // JS SUBMENU NO TOUCH
    $('.no-touchevents #navigation > .menu > li').mouseenter(function(){
        $(this).addClass('hover').siblings().removeClass('hover');
    });
    $('.no-touchevents #navigation > .menu > li').mouseleave(function(){
        $(this).removeClass('hover').siblings().removeClass('hover');
    });

    // JS SUBMENU TOUCHSCREEN
    $('.touchevents #navigation > .menu > li > a').click(function(e){
        if (!$(this).closest('li').hasClass('hover') && $(this).next('.menu').length > 0){
            e.preventDefault();
            $(this).closest('li').addClass('hover').siblings().removeClass('hover');
        }
    });
    // prevent top level menu items from triggering body click which will hide the submenu
    $('.touchevents #navigation a').click(function(e){
        e.stopPropagation();
    });
    // hide submenu when body is clicked
    $('.touchevents #page').click(function(e){
        $('#navigation *').removeClass('hover');
    });


    // SITE SEARCH BLOCK
    $('.no-touchevents .block-search *').focus(function(){
        $(this).closest('.block-search').addClass('expanded');
    });
    $('.no-touchevents .block-search *').mouseenter(function(){
        $(this).closest('.block-search').addClass('expanded');
    });
    $('.touchevents .block-search').click(function(e){
        if (!$(this).hasClass('expanded')){
            e.preventDefault();
            $(this).addClass('expanded');
        } else if ($(this).find('.form-text').val().length < 1){
            e.preventDefault();
        }
    });
    $('.no-touchevents .block-search').click(function(e){
        if (!$(this).hasClass('expanded')){
            e.preventDefault();
            $(this).addClass('expanded');
        } else if ($(this).find('.form-text').val().length < 1){
            e.preventDefault();
        }
    });




    /* MOBILE MENU TOGGLE */
    $(document).on('click','a.mobile-menu-trigger', function(e){
        e.preventDefault();
        $(this).toggleClass('active');
        $('#navigation').toggleClass('slide');
        $('body').toggleClass('menu-active');
    });

    $('#navigation li > ul.sub-menu').each(function () {
        $(this).parent().prepend('<li class="parentlink"><a href="#">' + $(this).prev('a').text() + '</a></li>');
    });

    $('#navigation li > li.parentlink').click(function (e) {
        e.preventDefault();
        $(this).closest('li.menu-item').toggleClass('reveal');
    });

    // keyboard accessibility
    $('.no-touchevents #navigation li > li.parentlink a').on('focus', function () {
        // remove class from all li's that do not have focus
        $('ul.sub-menu').parent('li').removeClass('reveal');
        $(this).closest('li.menu-item').addClass('reveal');
    });

    $('.no-touchevents #content a').on('focus', function () {
        $('body').removeClass('noscroll');
        $('.icon-menu a').removeClass('active');
        $('#navigation').find('li').removeClass('reveal');
        $('#site-navigation').removeClass('slide');
    });





    // Resize using throttle
    $(window).on('resize', throttle(function () {
        //set equalheights after window resizes
        $('.eqheight').conformity();
    }));


    $(window).load(function() {
        $('.eqheight').conformity();
    });





} )(jQuery);